/**
 * USe your computer as a screen for the Freeduino WhackAMole game
 *The Freeduino is the game engine and your computer is just throwing some images on the screen based on symbols the Freeduino 
 *sends over the serial port. These 50x50 pixel images are in the "data" folder within the sketch folder.
 *CKH 2012
 */


import processing.serial.*;

PImage crossed,mole,both,miss,hit,blank,mypic;

Serial myPort;  // Create object from Serial class
int val;      // Data received from the serial port
int state;
final int STATE_START    = 0;
final int STATE_PLAYING    = 1;
final int STATE_DONE    = 2;
int i;
int picwidth=50;
int picheight=50;
int picx=10;
int picy=10;
String doneString; //string that contains your score

void setup() 
{
  size(170, 170);
  
  crossed=loadImage("cross.png");
  mole=loadImage("mole.png");
  both=loadImage("both.png");
  miss=loadImage("miss.png");
  hit=loadImage("hit.png");
  blank=loadImage("blank.png");
  mypic=blank;
  // I know that the first port in the serial list on my mac
  // is always my  FTDI adaptor, so I open Serial.list()[0].
  // On Windows machines, this generally opens COM1.
  // Open whatever port is the one you're using.
  String portName = Serial.list()[0];
  myPort = new Serial(this, portName, 115200);
  state=STATE_START;
  i=0;
}

void draw()
{
  if (state==STATE_START){
     background(255);             // Set background to white
     fill(0);   //and text to black
     text("Hi!",50,20);
     text("Press button",20,50);
     text("to start.",30,80);
    
     if ( myPort.available() > 0) {  // If data is available,
       val = myPort.read();         // read it and store it in val
     }
 
     if (char(val) == '!') {              // If the ! char was sent, it is time to start playing
     state=STATE_PLAYING;
     } 
   
  }  
  
  
  if (state==STATE_PLAYING){
   while (myPort.available()>0) {
      val = myPort.read();
     
   switch(char(val)){//figure out what pic to draw
     case('Y')://it says You Lost, means done.
         doneString="";
         myPort.clear();//flush any additional read characters
         state=STATE_DONE;
         break;
     case('*')://there's a cursor
        i++;
        mypic=crossed;
        break;
     case('O')://there's a mole
        i++;
        mypic=mole;
        break;
      case('@')://cursor is over mole
        i++;
        mypic=both;
        break;
     case('x')://you missed
        i++;
        mypic=miss;
        break;
      case('#')://you hit
        i++;
        mypic=hit;
        break;
     case('.')://nothing here just a mole hole
        i++;
        mypic=blank;
        break;  
    }
    switch(i){ //Figures out which of the 9 cells to put the picture.
    //this is tedious to write out but computes fast and is easy to show what is going on
    case(10):
      i=1;//reset i
      picx=10;
      picy=10;
      break;
    case(1):
      picx=10;
      picy=10;
      break;
    case(2):
      picx=10+picwidth;
      picy=10;
      break;
    case(3):
      picx=10+2*picwidth;
      picy=10;
      break;
    case(4):
      picx=10;
      picy=10+picheight;
      break;
    case(5):
      picx=10+picwidth;
      picy=10+picheight;
      break;
    case(6):
      picx=10+2*picwidth;
      picy=10+picheight;
      break;
    case(7):
      picx=10;
      picy=10+2*picheight;
      break;
    case(8):
      picx=10+picwidth;
      picy=10+2*picheight;
      break;
    case(9):
      picx=10+2*picwidth;
      picy=10+2*picheight;
      break;
   
    }
    image(mypic,picx,picy); //draw the image at the right spot
   } 
  }
 if (state==STATE_DONE){
   background(255);
   fill(0);
   //text("Done",50,80);//get characters and score and print here
   text(doneString,20,20);
   if(myPort.available()>0){
     val=myPort.read();
     if(char(val)=='R'){
       state=STATE_START;//it's saying "Ready to play?" bc someone pressed the button
     }
     else {
       doneString+=char(val);
     }
   }
   
  
 }
 


}
 void destroy(){
   myPort.stop();
 }

